/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

//Native Gateway
function sendMessageToNative(message, jsonData) {
    //Convert jsonData to jsonDataString
    var jsonDataString = "";
    if (jsonData) //Todo: Handle properly
        jsonDataString = jsonData;
    try {
        if (window.JSObject) {
            var retVal = window.JSObject.messageFromHtml(message, jsonDataString);
            return retVal;
        }
    } catch (e) {
        return null;
    }
    return null;
}

function logMessage(message) {
    sendMessageToNative("logMessage", message);
}

function messageFromNative(message, jsonDataString) {
	try {
		var mainCtrl = $('#mainBody').scope().mainCtrl;
		var overlayCtrl = $('#overlayScreen').scope().overlayCtrl;
	} catch (e) {
		logMessage("Error in getting controllers. Error:" + e.message + " documentMode:" + document.documentMode + " UserAgent:" + navigator.userAgent);
	}

    //Convert jsonDataString to jsonData
    logMessage("Start messageFromNativeToUI: " + message);
    var jsonData = {};
    try {
        if (jsonDataString && jsonDataString != "")
            jsonData = $.parseJSON(jsonDataString);
    } catch (e) {
        jsonData = jsonDataString;
        logMessage("Error parsing Json object : " + e.message);
    }

    try {
        //Call appropriate function
        if (message == "initialize") {
            mainCtrl.initialize(jsonData);
        } else if (message == "showSpinnerScreen") {
            mainCtrl.showSpinnerScreen(jsonData);
        } else if (message == "showWebSSOWelcomeScreen") {
            mainCtrl.showWebSSOWelcomeScreen(jsonData);
        } else if (message == "showWebSSOPollingScreen") {
            mainCtrl.showWebSSOPollingScreen(jsonData);
        } else if (message == "showWelcomeScreen") {
            mainCtrl.showWelcomeScreen(jsonData);
        } else if (message == "showTestAppWelcomeScreen") {
            mainCtrl.showTestAppWelcomeScreen(jsonData);
        } else if (message == "showSurveyScreen") {
            mainCtrl.showSurveyScreen(jsonData);
        } else if (message == "showPiiScreen") {
            mainCtrl.showPiiScreen(jsonData);
        } else if (message == "showMainScreen") {
            mainCtrl.showMainScreen(jsonData);
        } else if (message == "updateProgress") {
            mainCtrl.updateProgress(jsonData);
        } else if (message == "updateCancelButtonState") {
            mainCtrl.updateCancelButtonState(jsonData);
        } else if (message == "showDefaultContent") {
            mainCtrl.showDefaultContent(jsonData, false);
        } else if (message == "showQuittingScreen") {
            mainCtrl.showQuittingScreen(jsonData);
        } else if (message == "showLaunchingProductScreen") {
            mainCtrl.showLaunchingProductScreen();
        } else if (message == "hideOverlay") {
            overlayCtrl.hideOverlay(jsonData);
        } else if (message == "showQuitConfirmation") {
            overlayCtrl.showQuitConfirmation(jsonData);
        } else if (message == "showErrorAlert") {
            overlayCtrl.showErrorAlert(jsonData);
        } else if (message == "showPathErrorAlert") {
            overlayCtrl.showPathErrorAlert(jsonData);
        } else if (message == "showCompatibilityErrorAlert") {
            overlayCtrl.showCompatibilityErrorAlert(jsonData);
        } else if (message == "showProxyAlert") {
            overlayCtrl.showProxyAlert(jsonData);
        } else if (message == "sendSMSResponse") {
            sendSMSResponse(jsonData);
        }
    } catch (e) {
        logMessage("Exception occured while handling message '" + message + "' : " + e.message);
    }

    $('#mainBody').scope().$apply();

    logMessage("End messageFromNativeToUI: " + message);
    return "";
}

function sendSMSResponse(jsonData) {

    if (isIframeAdded === true) {
        var status = jsonData.status;
        var responseCode = jsonData.responseCode;
        var data = "{\"message\":\"sendSMSResponse\",\"status\":\"" + status + "\",\"responseCode\":\"" + responseCode + "\"}";
        var ifr = document.getElementById('marketingIFrame');
        ifr.contentWindow.postMessage(data, "*");
    }
}

var receiveMessage = function (e) {
    var jsonData;
    try {
        jsonData = JSON.parse(e.data);
    } catch (e) {
        jsonData = e.data;
		logMessage("Error parsing Json object in receive message : " + e.data);
    }

    sendMessageToNative(jsonData.message, e.data);
}

//Load complete
function disableDragOnElement(elem) {
    elem.ondragstart = function () {
        return false;
    };
}

function attachEvt(elem, eventName, handler) {
    if (document.attachEvent)
        elem.attachEvent('on' + eventName, handler);
    else
        elem.addEventListener(eventName, handler);
}

function onLoadComplete() {
    var x = document.getElementsByTagName("img");
    if (x.length > 0) {
        for (var i = 0; i < x.length; i++) {
            disableDragOnElement(x[i]);
        }
    }

    attachEvt(window, 'message', receiveMessage);

    document.onselectstart = function (event) {
    	if (event.target.id == "proxyAlertUsername" || event.target.id == "proxyAlertPassword" || event.target.id == "contentUrl")
            return true;
        return false;
    }

    setTimeout(function () {
        sendMessageToNative("documentReady", "");
    }, 10);
}

var appModule = angular.module('AdobeInstaller', []);

//Utilities
function openUrl(event, piiLearnMoreClicked) {
    if (event.preventDefault)
        event.preventDefault();
    else
        event.returnValue = false;

    sendMessageToNative("openurl", event.target.href);
    if(piiLearnMoreClicked)
    {
        sendMessageToNative("piiLearnMoreClicked", "");
    }
}

function openFile(event) {
    if (event.preventDefault)
        event.preventDefault();
    else
        event.returnValue = false;

    sendMessageToNative("openFileURL", event.target.href);
}

function locationChangeLinkClicked(event) {
    if (event.preventDefault)
        event.preventDefault();
    else
        event.returnValue = false;

    sendMessageToNative("locationChangeClicked", self.pathResponseData);
    self.pathResponseData = "";
}

